/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.interaction;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.util.interaction.IRightClickBlockAction;
import net.dries007.tfc.util.interaction.IRightClickItemAction;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCommandBlock;
import net.minecraft.block.BlockStructure;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

@ParametersAreNonnullByDefault
final class ServerInteractionManager {
    ServerInteractionManager() {
    }

    @Nonnull
    static EnumActionResult processRightClickBlock(PlayerInteractEvent.RightClickBlock event, IRightClickBlockAction itemUseAction) {
        Block block;
        boolean bypass;
        World worldIn = event.getWorld();
        BlockPos pos = event.getPos();
        EntityPlayerMP player = (EntityPlayerMP)event.getEntityPlayer();
        EnumFacing facing = event.getFace();
        if (facing == null) {
            facing = EnumFacing.UP;
        }
        EnumHand hand = event.getHand();
        ItemStack stack = event.getItemStack();
        float hitX = 0.0f;
        float hitY = 0.0f;
        float hitZ = 0.0f;
        Vec3d hitVec = event.getHitVec();
        if (hitVec != null) {
            hitX = (float)(hitVec.field_72450_a - (double)pos.func_177958_n());
            hitY = (float)(hitVec.field_72448_b - (double)pos.func_177956_o());
            hitZ = (float)(hitVec.field_72449_c - (double)pos.func_177952_p());
        }
        EnumActionResult result = EnumActionResult.PASS;
        if (event.getUseItem() != Event.Result.DENY && (result = stack.onItemUseFirst((EntityPlayer)player, worldIn, pos, hand, facing, hitX, hitY, hitZ)) != EnumActionResult.PASS) {
            return result;
        }
        boolean bl = bypass = player.func_184614_ca().doesSneakBypassUse((IBlockAccess)worldIn, pos, (EntityPlayer)player) && player.func_184592_cb().doesSneakBypassUse((IBlockAccess)worldIn, pos, (EntityPlayer)player);
        if (!player.func_70093_af() || bypass || event.getUseBlock() == Event.Result.ALLOW) {
            IBlockState iblockstate = worldIn.func_180495_p(pos);
            if (event.getUseBlock() != Event.Result.DENY && iblockstate.func_177230_c().func_180639_a(worldIn, pos, iblockstate, (EntityPlayer)player, hand, facing, hitX, hitY, hitZ)) {
                result = EnumActionResult.SUCCESS;
            }
        }
        if (stack.func_190926_b()) {
            return EnumActionResult.PASS;
        }
        if (player.func_184811_cZ().func_185141_a(stack.func_77973_b())) {
            return EnumActionResult.PASS;
        }
        if (stack.func_77973_b() instanceof ItemBlock && !player.func_189808_dh() && ((block = ((ItemBlock)stack.func_77973_b()).func_179223_d()) instanceof BlockCommandBlock || block instanceof BlockStructure)) {
            return EnumActionResult.FAIL;
        }
        if (player.field_71134_c.func_73083_d()) {
            int j = stack.func_77960_j();
            int i = stack.func_190916_E();
            if (result != EnumActionResult.SUCCESS && event.getUseItem() != Event.Result.DENY || result == EnumActionResult.SUCCESS && event.getUseItem() == Event.Result.ALLOW) {
                EnumActionResult enumactionresult = itemUseAction.onRightClickBlock(stack, (EntityPlayer)player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
                if (enumactionresult == EnumActionResult.PASS) {
                    enumactionresult = stack.func_179546_a((EntityPlayer)player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
                }
                stack.func_77964_b(j);
                stack.func_190920_e(i);
                return enumactionresult;
            }
            return result;
        }
        if (result != EnumActionResult.SUCCESS && event.getUseItem() != Event.Result.DENY || result == EnumActionResult.SUCCESS && event.getUseItem() == Event.Result.ALLOW) {
            ItemStack copyBeforeUse = stack.func_77946_l();
            result = itemUseAction.onRightClickBlock(copyBeforeUse, (EntityPlayer)player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
            if (result == EnumActionResult.PASS) {
                result = copyBeforeUse.func_179546_a((EntityPlayer)player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
            }
            if (stack.func_190926_b()) {
                ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)copyBeforeUse, (EnumHand)hand);
            }
        }
        return result;
    }

    @Nonnull
    static EnumActionResult processRightClickItem(PlayerInteractEvent.RightClickItem event, IRightClickItemAction action) {
        return action.onRightClickItem(event.getWorld(), event.getEntityPlayer(), event.getHand());
    }
}

